% system solver DDE

% authors: Steven Maere, Krzysztof Wabnik

function [auxin, PIN3R, PIN3P, PIN3M, FLPR, FLPP] = Xsolver_5(modelfolder, model, generals_values, parms_values, t, nt, auxinInput, yinitial, selected_parms)

% Read system
model = str2func(model);

yinitial=reshape(yinitial,1,generals_values(1)*generals_values(2)*generals_values(3)); % vectorize

auxin=[];
PIN3R=[];
PIN3P=[];
PIN3M=[];
FLPR=[];
FLPP=[];
parameters_final=[];
opts = [];

% solve

sol = ode23s(model,[0 generals_values(8)],yinitial',opts, parms_values, generals_values, nt, auxinInput');
y=deval(sol,t);

auxin=[auxin; y(1,:)];
PIN3R=[PIN3R; y(2,:)];
PIN3P=[PIN3P; y(3,:)];
PIN3M=[PIN3M; y(4,:)];
FLPR=[FLPR; y(5,:)];
FLPP=[FLPP; y(6,:)];

end
