% FFM and no FFM auxin signalling system simulation under specific
% parameter settings

% authors: Steven Maere, Krzysztof Wabnik

% default parameter values as a function of 0.1s time steps 

%1 \beta_A:0                
%2 \delta_A:0.0000005
%3 a/V:0.06               
%4 p_{AH}:3.3               
%5 f_{AH}^{wall}:0.334     
%6 f_{AH}^{cell}:0.003      
%7 p_{A-}:1.24             
%8 n_3:2.0                
%9 f_{A-}^{wall}:0.666    
%10 N_{influx}:0.07        
%11 K_A:1.0
%12 f_{A-}^{cell}:0.997    
%13 N_{efflux}:4.0        
%14 n_1:1.0              
%15 ARF7:1                 
%16 \omega_{ARF7}:0        
%17 K_{ARF7}: 0.5
%18 \alpha_{PIN3}:0.00000056
%19 K_{AP}:0.3
%20 K_{FP}:0.6              
%21 \gamma_{PIN3}:0.000019
%22 \beta_{PIN3}:0.010
%23 \delta_{PIN3}:0.000010
%24 k_1:0.000039
%25 n_5:1.0                
%26 K:0.4
%27 k_2:0.000039
%28 \alpha_{FLP}:0.00000056 
%29 K_{AF}:0.3              
%30 \gamma_{FLP}:0.000019   
%31 \beta_{FLP}:0.01        
%32 \delta_{FLP}:0.000039   
%33 n_4:2.0              
%34 R_P:0.001
%35 n_2:2.0              

% read parameters
if exist(strcat('./','default','.parms'),'file')
    filename = strcat('./','default','.parms');
    fid = fopen(filename);
    parameters = textscan(fid,'%s %f','Delimiter',':','CommentStyle','%');
    fclose(fid);
end

parameter_names = parameters{1,1};
parameter_values = parameters{1,2};

nogenerals = parameter_values(1,1);

generals_values = parameter_values(2:nogenerals+1,:)';
generals_names = parameter_names(2:nogenerals+1,:)';

parms_values = parameter_values(nogenerals+2:end,:)';
parms_names = parameter_names(nogenerals+2:end,:)';

% Generate time space (resolution 1 min for t=600 steps)

t=linspace(0,generals_values(8),generals_values(8));
nt = linspace(0,generals_values(8),generals_values(8)); 

%calculate steady state initials under background extracellular auxin  = 0.1 uM

auxinInput = ones(generals_values(8),1).*0.1;

%for FFM scenario: set initials to anything
yinitial=[];

%initial auxin
yinitial(1) = 0.0425;

%initial PIN3
yinitial(2) = 0.0082;
yinitial(3) = 4.4084;
yinitial(4) = 0.00063327;

%initial FLP
yinitial(5) = 0.0019;
yinitial(6) = 0.3381;

[auxin, PIN3R, PIN3P, PIN3M, FLPR, FLPP] = Xsolver_5('./', 'FFM_5', generals_values, parms_values, t, nt, auxinInput, yinitial,[]);
ARFa= parms_values(15) .*(parms_values(16) + auxin.^parms_values(25)./(parms_values(17)^parms_values(25) +auxin.^parms_values(25)));

%for no FFM scenario: set initials to anything
yinitial=[];

%initial auxin
yinitial(1) = 0.0647;

%initial PIN3
yinitial(2) = 0.0038;
yinitial(3) = 1.9789;
yinitial(4) = 0.00029521;

%initial FLP
yinitial(5) = 0;
yinitial(6) = 0;

[flpauxin, flpPIN3R, flpPIN3P, flpPIN3M, flpFLPR, flpFLPP] = Xsolver_5('./', 'noFFM_5', generals_values, parms_values, t, nt, auxinInput, yinitial,[]);
flpARFa= parms_values(15) .*(parms_values(16) + flpauxin.^parms_values(25)./(parms_values(17)^parms_values(25) +flpauxin.^parms_values(25)));


%simulate auxin pulses at times t2, duration d, amplitude a

t2=144000;
d=72000;
a=1.0;
auxinInput = ones(generals_values(8),1).*0.1;
for j=t2:1:t2+d-1
auxinInput(j) = a; 
end
t2=432000;
d=72000;
a=1.0;
for j=t2:1:t2+d-1
auxinInput(j) = a; 
end
t3=936000;
d=72000;
a=1.0;
for j=t3:1:t3+d-1
auxinInput(j) = a; 
end

%FFM scenario: set initials based on steady-state calculated for extracellular auxin [] = 0.1uM
yinitial=[];

%initial auxin
yinitial(1) = auxin(1440000);

%initial PIN3
yinitial(2) = PIN3R(1440000);
yinitial(3) = PIN3P(1440000);
yinitial(4) = PIN3M(1440000);
%yinitial(4) = 0.65;

%initial FLP
yinitial(5) = FLPR(1440000);
yinitial(6) = FLPP(1440000);

[auxin, PIN3R, PIN3P, PIN3M, FLPR, FLPP] = Xsolver_5('./', 'FFM_5', generals_values, parms_values, t, nt, auxinInput, yinitial, []);
ARFa= parms_values(15) .*(parms_values(16) + auxin.^parms_values(25)./(parms_values(17)^parms_values(25) +auxin.^parms_values(25)));

%noFFM scenario: set initials based on steady-state calculated for extracellular auxin [] = 0.1uM
yinitial=[];

%initial auxin
yinitial(1) = flpauxin(1440000);

%initial PIN3
yinitial(2) = flpPIN3R(1440000);
yinitial(3) = flpPIN3P(1440000);
yinitial(4) = flpPIN3M(1440000);
%yinitial(4) = 0.65;

%initial FLP
yinitial(5) = 0;
yinitial(6) = 0;

[flpauxin, flpPIN3R, flpPIN3P, flpPIN3M, flpFLPR, flpFLPP] = Xsolver_5('./', 'noFFM_5', generals_values, parms_values, t, nt, auxinInput, yinitial, []);
flpARFa= parms_values(15) .*(parms_values(16) + flpauxin.^parms_values(25)./(parms_values(17)^parms_values(25) +flpauxin.^parms_values(25)));

%figures

t=0:1/36000:40;
t(1440001)=[];

figure(1);

subplot(3,2,1);
plot(t,[PIN3R; flpPIN3R]);
%title('PIN3 mRNA []');
xlabel('time [h]');
ylabel('PIN3 mRNA [uM]');
legend('WT','flp');

subplot(3,2,2);
plot(t,[PIN3P+PIN3M*parms_values(3)*10^5; flpPIN3P+flpPIN3M*parms_values(3)*10^5]);
%title('PIN3 protein [] (intracellular + membrane-bound)');
xlabel('time [h]');
ylabel('total PIN3 protein [uM]');
%legend('WT','flp');

subplot(3,2,3);
plot(t,[FLPR; flpFLPR]);
%title('FLP mRNA');
xlabel('time [h]');
ylabel('FLP mRNA [uM]');
%legend('WT','flp');

subplot(3,2,4);
plot(t,[FLPP; flpFLPP]);
%title('FLP');
xlabel('time [h]');
ylabel('FLP protein [uM]');
%legend('WT','flp');

subplot(3,2,5);
plot(t,[auxin;flpauxin]);
%title('auxin');
xlabel('time [h]');
ylabel('intracellular auxin [uM]');
%legend('WT','flp');

subplot(3,2,6);
plot(t,[ARFa;flpARFa]);
%title('ARF7');
xlabel('time [h]');
ylabel('active ARF7 [uM]');
%legend('WT','flp');


