% parameter screen for PIN3 response delay behavior upon auxin stimulus
% shutdown

% authors: Steven Maere, Krzysztof Wabnik

% mean (on log-scale) parameter values for screen as a function of 0.1s time steps (screen 1 order of
% magnitude above and below):

%1 \beta_A:0                change default from 0 to 0.0000005 when screening \beta_A
%2 \delta_A:0.0000005
%3 a/V:0.06                 not varied 
%4 p_{AH}:3.3               not varied
%5 f_{AH}^{wall}:0.334      not varied
%6 f_{AH}^{cell}:0.003      not varied
%7 p_{A-}:1.24              not varied
%8 n_3:2.0                  varied 1-3
%9 f_{A-}^{wall}:0.666      not varied
%10 N_{influx}:0.07         not varied
%11 K_A:1.0
%12 f_{A-}^{cell}:0.997     not varied
%13 N_{efflux}:4.0          not varied
%14 n_1:1.0                 varied 1-3
%15 ARF7:1                  not varied
%16 \omega_{ARF7}:0         varied 0-1
%17 K_{ARF7}: 0.5
%18 \alpha_{PIN3}:0.00000056
%19 K_{AP}:0.3
%20 K_{FP}:0.6              
%21 \gamma_{PIN3}:0.000019
%22 \beta_{PIN3}:0.010
%23 \delta_{PIN3}:0.000010
%24 k_1:0.000039
%25 n_5:1.0                 varied 1-3
%26 K:0.4
%27 k_2:0.000039
%28 \alpha_{FLP}:0.00000056 
%29 K_{AF}:0.3              
%30 \gamma_{FLP}:0.000019   if \gamma_{FLP} becomes too low, decay is no longer within simulation range 
%31 \beta_{FLP}:0.01        
%32 \delta_{FLP}:0.000039   
%33 n_4:2.0                 varied 1-3
%34 R_P:0.001
%35 n_2:2.0                 varied 1-3

% parameter dimensions (warning: adapt scale on plots to time steps of 0.1s instead of 1s)
dimensions = {'\muM s^{-1}' 's^{-1}' '\mum^{-1}' '\mum s^{-1}' '' '' '\mum s^{-1}' '' '' '' '\muM' '' '' '' '\muM' '' '\muM' '\muM s^{-1}' '\muM' '\muM' 's^{-1}' 's^{-1}' 's^{-1}' 's^{-1}' '' '\muM' 's^{-1}' '\muM s^{-1}' '\muM' 's^{-1}' 's^{-1}' 's^{-1}' '' '\mumol dm^{-2}' ''};

% read parameters
if exist(strcat('./','default','.parms'),'file')
    filename = strcat('./','default','.parms');
    fid = fopen(filename);
    parameters = textscan(fid,'%s %f','Delimiter',':','CommentStyle','%');
    fclose(fid);
end

parameter_names = parameters{1,1};
parameter_values = parameters{1,2};

nogenerals = parameter_values(1,1);

generals_values = parameter_values(2:nogenerals+1,:)';
generals_names = parameter_names(2:nogenerals+1,:)';

parms_values = parameter_values(nogenerals+2:end,:)';
parms_names = parameter_names(nogenerals+2:end,:)';

% Generate time space (resolution 1 min for t=600 steps)

t=linspace(0,generals_values(8),generals_values(8));
nt = linspace(0,generals_values(8),generals_values(8)); 

%subplot id
l=0;

for j=1:1:size(parms_values,2)

j
ratio = [];
scale = [];
    
%select parameter to screen...

if ((j==3)||(j==4)||(j==5)||(j==6)||(j==7)||(j==9)||(j==10)||(j==12)||(j==13)||(j==15))
    continue
elseif (j==16)
    selected_parm = j;  
    scale = 0:0.1:1;
    ratio = zeros(size(scale));
    l = l+1;
elseif ((j==8)||(j==14)||(j==25)||(j==33)||(j==35))
    selected_parm = j;  
    scale = 0:0.1:2;
    ratio = zeros(size(scale));
    l = l+1;
else
    selected_parm = j;
    scale = [0.1:0.1:0.9 1:1:10];
    ratio = zeros(size(scale));
    l = l+1;
end

for k=1:1:size(scale,2)

k
    
% adjust selected parameter    
parms_screen = parms_values;
if (j==1)
    parms_screen(j) = scale(k)*0.0000005;
elseif (j==16)
    parms_screen(j) = scale(k);
elseif ((j==8)||(j==14)||(j==25)||(j==33)||(j==35))
    parms_screen(j) = 1 + scale(k);    
else
    parms_screen(selected_parm) = scale(k)*parms_screen(selected_parm);
end

%set more or less random initials
yinitial=[];

%initial auxin
yinitial(1) = 0.0425;

%initial PIN3
yinitial(2) = 0.0082;
yinitial(3) = 4.4084;
yinitial(4) = 0.00063327;
%yinitial(4) = 0.65;

%initial FLP
yinitial(5) = 0.0019;
yinitial(6) = 0.3381;

%calculate steady state initials under background extracellular auxin  =
%0.1 uM for FFM model

auxinInput = ones(generals_values(8),1).*0.1;

[auxin, PIN3R, PIN3P, PIN3M, FLPR, FLPP] = Xsolver_5('./', 'FFM_5', generals_values, parms_screen, t, nt, auxinInput, yinitial, []);
ARFa= parms_screen(15) .*(parms_screen(16) + auxin.^parms_screen(25)./(parms_screen(17)^parms_screen(25) +auxin.^parms_screen(25)));

%set steady-state initials 0.1 uM auxin, FFM model
ss_low_FFM=[];

%initial auxin
ss_low_FFM(1) = auxin(1440000);

%initial PIN3
ss_low_FFM(2) = PIN3R(1440000);
ss_low_FFM(3) = PIN3P(1440000);
ss_low_FFM(4) = PIN3M(1440000);

%initial FLP
ss_low_FFM(5) = FLPR(1440000);
ss_low_FFM(6) = FLPP(1440000);

%calculate steady state initials under background extracellular auxin  =
%1 uM for FFM model

auxinInput = ones(generals_values(8),1);

[auxin, PIN3R, PIN3P, PIN3M, FLPR, FLPP] = Xsolver_5('./', 'FFM_5', generals_values, parms_screen, t, nt, auxinInput, yinitial, []);
ARFa= parms_screen(15) .*(parms_screen(16) + auxin.^parms_screen(25)./(parms_screen(17)^parms_screen(25) +auxin.^parms_screen(25)));

%set steady-state initials 0.1 uM auxin, FFM model
ss_high_FFM=[];

%initial auxin
ss_high_FFM(1) = auxin(1440000);

%initial PIN3
ss_high_FFM(2) = PIN3R(1440000);
ss_high_FFM(3) = PIN3P(1440000);
ss_high_FFM(4) = PIN3M(1440000);

%initial FLP
ss_high_FFM(5) = FLPR(1440000);
ss_high_FFM(6) = FLPP(1440000);


%calculate steady state initials under background extracellular auxin  =
%0.1 uM for noFFM model

auxinInput = ones(generals_values(8),1).*0.1;

%initial FLP
yinitial(5) = 0;
yinitial(6) = 0;

[flpauxin, flpPIN3R, flpPIN3P, flpPIN3M, flpFLPR, flpFLPP] = Xsolver_5('./', 'noFFM_5', generals_values, parms_screen, t,nt, auxinInput, yinitial, []);
flpARFa= parms_screen(15) .*(parms_screen(16) + flpauxin.^parms_screen(25)./(parms_screen(17)^parms_screen(25) +flpauxin.^parms_screen(25)));

%set steady-state initials 0.1 uM auxin, noFFM model
ss_low_noFFM=[];

%initial auxin
ss_low_noFFM(1) = flpauxin(1440000);

%initial PIN3
ss_low_noFFM(2) = flpPIN3R(1440000);
ss_low_noFFM(3) = flpPIN3P(1440000);
ss_low_noFFM(4) = flpPIN3M(1440000);

%initial FLP
ss_low_noFFM(5) = flpFLPR(1440000);
ss_low_noFFM(6) = flpFLPP(1440000);

%calculate steady state initials under background extracellular auxin  =
%1 uM for no FFL model

auxinInput = ones(generals_values(8),1);

%initial FLP
yinitial(5) = 0;
yinitial(6) = 0;

[flpauxin, flpPIN3R, flpPIN3P, flpPIN3M, flpFLPR, flpFLPP] = Xsolver_5('./', 'noFFM_5', generals_values, parms_screen, t,nt, auxinInput, yinitial, []);
flpARFa= parms_screen(15) .*(parms_screen(16) + flpauxin.^parms_screen(25)./(parms_screen(17)^parms_screen(25) +flpauxin.^parms_screen(25)));

%set steady-state initials 0.1 uM auxin, no FFL model
ss_high_noFFM=[];

%initial auxin
ss_high_noFFM(1) = flpauxin(1440000);

%initial PIN3
ss_high_noFFM(2) = flpPIN3R(1440000);
ss_high_noFFM(3) = flpPIN3P(1440000);
ss_high_noFFM(4) = flpPIN3M(1440000);

%initial FLP
ss_high_noFFM(5) = flpFLPR(1440000);
ss_high_noFFM(6) = flpFLPP(1440000);

%run pulse shutdown starting from high auxin steady state

auxinInput = ones(generals_values(8),1).*0.1;
% burn-in
auxinInput(1:100000) = 1;

[auxin_FLP_shutdown, PIN3R_FLP_shutdown, PIN3P_FLP_shutdown, PIN3M_FLP_shutdown, FLPR_FLP_shutdown, FLPP_FLP_shutdown] = Xsolver_5('./', 'FFM_5', generals_values, parms_screen, t, nt, auxinInput, ss_high_FFM, []);
ARFa_FLP_shutdown= parms_screen(15) .*(parms_screen(16) + auxin.^parms_screen(25)./(parms_screen(17)^parms_screen(25) +auxin.^parms_screen(25)));
[auxin_noFLP_shutdown, PIN3R_noFLP_shutdown, PIN3P_noFLP_shutdown, PIN3M_noFLP_shutdown, FLPR_noFLP_shutdown, FLPP_noFLP_shutdown] = Xsolver_5('./', 'noFFM_5', generals_values, parms_screen, t, nt, auxinInput, ss_high_noFFM, []);
ARFa_noFLP_shutdown= parms_screen(15) .*(parms_screen(16) + auxin.^parms_screen(25)./(parms_screen(17)^parms_screen(25) +auxin.^parms_screen(25)));

figure(2)
plot(1:1:1440000,PIN3P_FLP_shutdown + PIN3M_FLP_shutdown*parms_screen(3)*10^5);
hold on;
plot(1:1:1440000,PIN3P_noFLP_shutdown + PIN3M_noFLP_shutdown*parms_screen(3)*10^5);
hold off;
title(k);
xlabel('t');
ylabel('PIN3 Protein');

%calculate ratio of PIN3P + PIN3M [] halving time (response time)

%FFM scenario
found = false;
i=100001;
FLP_halving_time = 0;
while found == false
    if PIN3P_FLP_shutdown(i) + PIN3M_FLP_shutdown(i)*parms_screen(3)*10^5 < (ss_high_FFM(3)+ss_high_FFM(4)*parms_screen(3)*10^5 + ss_low_FFM(3)+ss_low_FFM(4)*parms_screen(3)*10^5)/2
        FLP_halving_time = i-100001;
        found = true;
    elseif i == 1440000
        found = true;    
    end
    i=i+1;
end

% noFFM scenario
found = false;
i=100001;
noFLP_halving_time = 0;
while found == false
    if PIN3P_noFLP_shutdown(i) + PIN3M_noFLP_shutdown(i)*parms_screen(3)*10^5  < (ss_high_noFFM(3)+ss_high_noFFM(4)*parms_screen(3)*10^5+ss_low_noFFM(3)+ss_low_noFFM(4)*parms_screen(3)*10^5)/2
        noFLP_halving_time = i-100001;
        found = true;
    elseif i == 1440000
        found = true;    
    end
    i=i+1;
end

%ratio response time FFM/noFFM
ratio(k) = FLP_halving_time/noFLP_halving_time;

end


figure(1);
subplot(5,5,l);
if (j==16)
    plot(scale,ratio);
elseif ((j==8)||(j==14)||(j==25)||(j==33)||(j==35))
    plot(scale + 1,ratio);
elseif (j==1)
    %rescaled from (0.1s)-1 to s-1
    semilogx(scale.*0.000005,ratio);   
elseif ((j==2)||(j==18)||(j==21)||(j==22)||(j==23)||(j==24)||(j==27)||(j==28)||(j==30)||(j==31)||(j==32))
    %rescaled from (0.1s)-1 to s-1
    semilogx(scale.*parms_values(selected_parm).*10,ratio);
else
    semilogx(scale.*parms_values(selected_parm),ratio);
end
title(parms_names(selected_parm));
if(strcmp(dimensions(j),'') == 0)
    xlabel(strcat(parms_names(selected_parm),' (',dimensions(j),')'));
else
    xlabel(parms_names(selected_parm)); 
end
%ylabel('Response time ratio FFM / no FFM');

end


