%================================================================================================
%if changed or a new function added recompile :
%mcc -m test.m -a ./functions/*.m
%================================================================================================

%authors: Steven Maere, Krzysztof Wabnik

%based initially on Jonsson et al 2006 PNAS

%parameter values
%1 \beta_A
%2 \delta_A
%3 a/V
%4 p_{AH}
%5 f_{AH}^{wall}
%6 f_{AH}^{cell}
%7 p_{A-}
%8 n_3
%9 f_{A-}^{wall}
%10 N_{influx}
%11 K_A
%12 f_{A-}^{cell}
%13 N_{efflux}
%14 n_1
%15 ARF7
%16 \omega_{ARF7}
%17 K_{ARF7}
%18 \alpha_{PIN3}
%19 K_{AP}
%20 K_{FP}
%21 \gamma_{PIN3}
%22 \beta_{PIN3}
%23 \delta_{PIN3}
%24 k_1
%25 n_5
%26 K
%27 k_2
%28 \alpha_{FLP}
%29 K_{AF}
%30 \gamma_{FLP}
%31 \beta_{FLP}
%32 \delta_{FLP}
%33 n_4
%34 R_P
%35 n_2

function dy = FFM_5(t,y,p,g,nt,auxinInput)

%define variables

%intracellular auxin []
Auxin = y(1:g(2)*g(3));

%PIN3 RNA []
PIN3RNA = y(g(2)*g(3)+1:2*g(2)*g(3));

%intracellular PIN3 protein []
PIN3P = y(2*g(2)*g(3)+1:3*g(2)*g(3));

%PIN3 membrane protein []
PIN3M = y(3*g(2)*g(3)+1:4*g(2)*g(3));

%FLP RNA []
FLPRNA = y(4*g(2)*g(3)+1:5*g(2)*g(3));

%FLP protein []
FLPP = y(5*g(2)*g(3)+1:6*g(2)*g(3));

Auxin=reshape(Auxin,g(2),g(3)); 
PIN3RNA=reshape(PIN3RNA,g(2),g(3)); 
PIN3P=reshape(PIN3P,g(2),g(3)); 
PIN3M=reshape(PIN3M,g(2),g(3)); 
FLPRNA=reshape(FLPRNA,g(2),g(3)); 
FLPP=reshape(FLPP,g(2),g(3)); 

%Boundary no flux

%%% differential equations reset    

for i=1:g(2)
  for j=1:g(3)
    
    dAuxin(i,j)=0;
    dPIN3RNA(i,j)=0;
    dPIN3P(i,j)=0;
    dPIN3M(i,j)=0;
    dFLPRNA(i,j)=0;
    dFLPP(i,j)=0;
 
  end
end

%input function auxin

%interpolate auxin input at time t
ns = interp1(nt,auxinInput,t);

%ODEs

%calculate intracellular auxin []

dAuxin(1,1) = p(1) - p(2)*Auxin(1,1) + p(3)*p(4)*(p(5)*ns-p(6)*Auxin(1,1)) + p(3)*p(7)*(PIN3M(1,1)/p(34))*(p(9)*p(10)*(p(11)*ns/(p(11)+ns))-p(12)*p(13)*(p(11)*Auxin(1,1)/(p(11)+Auxin(1,1))));

%calculate active ARF7 []

ARFa= p(15)*(p(16) + Auxin(1,1)^p(14)/(p(17)^p(14) + Auxin(1,1)^p(14)));

%calculate PIN3 RNA []

dPIN3RNA = p(18)*((1/(p(19)^p(8)))*ARFa^p(8) + (1/p(20)^p(33))*FLPP(1,1)^p(33))/(1 + (1/(p(19)^p(8)))*ARFa^p(8) + (1/p(20)^p(33))*FLPP(1,1)^p(33) ) - p(21)*PIN3RNA(1,1);

% calculate PIN3 intracellular protein []

dPIN3P = p(22)*PIN3RNA(1,1) - p(23)*PIN3P(1,1) - PIN3P(1,1)*p(24) + p(3)*(10^5)*p(27)*PIN3M(1,1)*(p(26)^p(25)./(p(26)^p(25)+ns^p(25)));

% calculate PIN3 membrane []

dPIN3M = (10^(-5))/p(3) * PIN3P(1,1)*p(24) - p(27)*PIN3M(1,1)*(p(26)^p(25)./(p(26)^p(25)+ns^p(25))) - p(23)*PIN3M(1,1);

% calculate FLP RNA []

dFLPRNA = p(28)*((1/(p(29)^p(35)))*ARFa^p(35))/(1 + (1/(p(29)^p(35)))*ARFa^p(35)) - p(30)*FLPRNA(1,1);

% calculate FLP protein []

dFLPP = p(31)*FLPRNA(1,1) - p(32)*FLPP(1,1);


dAuxin=reshape(dAuxin,g(2)*g(3),1); 
dPIN3RNA=reshape(dPIN3RNA,g(2)*g(3),1); 
dPIN3P=reshape(dPIN3P,g(2)*g(3),1);
dPIN3M=reshape(dPIN3M,g(2)*g(3),1);
dFLPRNA=reshape(dFLPRNA,g(2)*g(3),1);
dFLPP=reshape(dFLPP,g(2)*g(3),1);  
 

dy = [dAuxin ; dPIN3RNA ; dPIN3P; dPIN3M; dFLPRNA;  dFLPP];


end

